<?php
require_once 'config.php';
require_once 'functions.php';

// Clean up expired messages
cleanup_messages();

// دریافت داده‌های ورودی از webhook
$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (!$update) exit;

// هندل پیام‌های معمولی
if (isset($update['message'])) {
    $message = $update['message'];
    $chat_id = $message['chat']['id'];
    $user_id = $message['from']['id'];
    $username = $message['from']['username'] ?? 'Unknown';
    $text = trim($message['text'] ?? '');

    // ذخیره کاربر
    add_user($user_id, $username);

    // بررسی وضعیت کاربر
    $state = get_user_state($user_id);

    // بررسی دستور start با پارامتر
    if (preg_match('/^\/start\s+(\S+)/', $text, $matches)) {
        $unique_id = $matches[1];
        
        if (!check_user_membership($user_id)) {
            $message = get_forced_join_message();
            send_message($chat_id, $message, get_channel_keyboard());
            set_user_state($user_id, 'waiting_verification_' . $unique_id);
            exit;
        }

        $original_link = get_link($unique_id);
        if ($original_link) {
            $reply_markup = [
                'inline_keyboard' => [
                    [['text' => 'دریافت فایل', 'url' => $original_link]]
                ]
            ];
            send_temporary_message($chat_id, "برای دریافت فایل روی دکمه زیر کلیک کنید 👇", $reply_markup);
        } else {
            send_message($chat_id, "❌ لینک یافت نشد یا منقضی شده است.");
        }
        return;
    }
    // دستور start ساده
    elseif ($text == '/start') {
        // فقط متن استارت را نمایش می‌دهیم (بدون چک جوین اجباری)
        $keyboard = get_custom_buttons_keyboard();
        send_start_message($chat_id, $keyboard);
        return;
    }
    // بررسی کلیک روی دکمه‌های سفارشی
    elseif (!is_admin($user_id) && get_custom_button_by_name($text)) {
        $button = get_custom_button_by_name($text);
        
        // ساخت پیام
        $response_text = $button['content'];
        
        // اگر دکمه‌های شیشه‌ای داره
        $inline_keyboard = null;
        if (isset($button['inline_buttons']) && !empty($button['inline_buttons'])) {
            $keyboard_rows = [];
            foreach ($button['inline_buttons'] as $inline_btn) {
                $keyboard_rows[] = [
                    ['text' => $inline_btn['text'], 'url' => $inline_btn['url']]
                ];
            }
            $inline_keyboard = ['inline_keyboard' => $keyboard_rows];
        }
        
        send_message($chat_id, $response_text, $inline_keyboard);
        return;
    } elseif ($state == 'waiting_for_broadcast' && is_admin($user_id)) {
        // ارسال پیام اولیه با وضعیت
        $status_message = send_message($chat_id, "📊 در حال آماده‌سازی ارسال همگانی...\n\n👥 تعداد کل کاربران: " . number_format(count(load_users())));
        if ($status_message) {
            // شروع ارسال
            broadcast_message($text, $chat_id, $status_message['message_id']);
            
            // ارسال پیام تایید به ادمین
            send_message($chat_id, "✅ ارسال همگانی شروع شد.\n⏱ پیام‌ها به تدریج (هر دقیقه 100 نفر) ارسال خواهند شد.");
        }
        set_user_state($user_id, null);
    } elseif ($state == 'waiting_for_forward' && is_admin($user_id)) {
        if (isset($message['forward_from_chat'])) {
            // ارسال پیام اولیه با وضعیت
            $status_message = send_message($chat_id, "📊 در حال آماده‌سازی فوروارد همگانی...\n\n👥 تعداد کل کاربران: " . number_format(count(load_users())));
            if ($status_message) {
                // شروع فوروارد
                $from_chat_id = $message['forward_from_chat']['id'];
                $message_id = $message['forward_from_message_id'] ?? $message['message_id'];
                forward_message_to_all($from_chat_id, $message_id, $chat_id, $status_message['message_id']);
                
                // ارسال پیام تایید به ادمین
                send_message($chat_id, "✅ فوروارد همگانی شروع شد.\n⏱ پیام‌ها به تدریج (هر دقیقه 100 نفر) فوروارد خواهند شد.");
            }
        } else {
            send_message($chat_id, "❌ لطفاً یک پیام را فوروارد کنید.");
        }
        set_user_state($user_id, null);
        } elseif ($state == 'waiting_for_public_channel_name' && is_admin($user_id)) {
        $channel_name = trim($text);
        
        // ذخیره نام در فایل موقت
        $temp_file = __DIR__ . '/temp_public_channel_' . $user_id . '.json';
        $temp_data = ['name' => $channel_name];
        file_put_contents($temp_file, json_encode($temp_data, JSON_UNESCAPED_UNICODE));
        
        set_user_state($user_id, 'waiting_for_public_channel_username');
        
        $msg = "➕ <b>افزودن کانال عمومی - مرحله 2 از 2</b>\n\n";
        $msg .= "✅ نام نمایشی: <b>$channel_name</b>\n\n";
        $msg .= "🌐 حالا نام کاربری (username) کانال را بدون @ ارسال کنید:\n\n";
        $msg .= "📝 مثال:\n";
        $msg .= "<code>mychannel</code>";
        
        send_message($chat_id, $msg);
    } elseif ($state == 'waiting_for_public_channel_username' && is_admin($user_id)) {
        $username = str_replace('@', '', trim($text));
        
        // خواندن نام از فایل موقت
        $temp_file = __DIR__ . '/temp_public_channel_' . $user_id . '.json';
        if (file_exists($temp_file)) {
            $temp_data = json_decode(file_get_contents($temp_file), true);
            
            $channel_data = [
                'id' => $username,
                'name' => $temp_data['name'],
                'link' => 'https://t.me/' . $username
            ];
            
            if (add_required_channel($channel_data)) {
                send_message($chat_id, "✅ کانال عمومی «{$temp_data['name']}» با موفقیت اضافه شد!\n\n🌐 Username: @$username");
            } else {
                send_message($chat_id, "❌ این کانال قبلاً اضافه شده است.");
            }
            
            // حذف فایل موقت
            unlink($temp_file);
            set_user_state($user_id, null);
        } else {
            send_message($chat_id, "❌ خطا! لطفاً دوباره از ابتدا شروع کنید.");
            set_user_state($user_id, null);
        }
    } elseif ($state == 'waiting_for_private_channel_name' && is_admin($user_id)) {
        $channel_name = trim($text);
        
        // ذخیره نام در فایل موقت
        $temp_file = __DIR__ . '/temp_channel_' . $user_id . '.json';
        $temp_data = ['name' => $channel_name];
        file_put_contents($temp_file, json_encode($temp_data, JSON_UNESCAPED_UNICODE));
        
        set_user_state($user_id, 'waiting_for_private_channel_link');
        
        $msg = "➕ <b>افزودن کانال خصوصی - مرحله 2 از 3</b>\n\n";
        $msg .= "✅ نام کانال: <b>$channel_name</b>\n\n";
        $msg .= "🔗 حالا لینک دعوت کانال را ارسال کنید:\n\n";
        $msg .= "📝 مثال:\n";
        $msg .= "<code>https://t.me/+AbCdEfGhIj</code>";
        
        send_message($chat_id, $msg);
    } elseif ($state == 'waiting_for_private_channel_link' && is_admin($user_id)) {
        $link = trim($text);
        
        // بررسی فرمت لینک
        if (strpos($link, 't.me/') === false) {
            send_message($chat_id, "❌ لینک نامعتبر است!\n\nلینک باید از t.me باشد.\n\nمثال: <code>https://t.me/+AbCdEfGhIj</code>");
            return;
        }
        
        // خواندن نام از فایل موقت
        $temp_file = __DIR__ . '/temp_channel_' . $user_id . '.json';
        if (file_exists($temp_file)) {
            $temp_data = json_decode(file_get_contents($temp_file), true);
            $temp_data['link'] = $link;
            file_put_contents($temp_file, json_encode($temp_data, JSON_UNESCAPED_UNICODE));
        }
        
        set_user_state($user_id, 'waiting_for_private_channel_forward');
        
        $msg = "➕ <b>افزودن کانال خصوصی - مرحله 3 از 3</b>\n\n";
        $msg .= "✅ نام: <b>{$temp_data['name']}</b>\n";
        $msg .= "✅ لینک: <code>$link</code>\n\n";
        $msg .= "📤 حالا <b>یک پیام از کانال را فوروارد کنید</b>\n";
        $msg .= "(این کار برای دریافت شناسه کانال است)\n\n";
        $msg .= "⚠️ <b>مهم:</b> ربات باید Admin کانال باشد!";
        
        send_message($chat_id, $msg);
    } elseif ($state == 'waiting_for_private_channel_forward' && is_admin($user_id)) {
        if (isset($message['forward_from_chat'])) {
            $channel_id = $message['forward_from_chat']['id'];
            
            // خواندن اطلاعات از فایل موقت
            $temp_file = __DIR__ . '/temp_channel_' . $user_id . '.json';
            if (file_exists($temp_file)) {
                $temp_data = json_decode(file_get_contents($temp_file), true);
                
                $channel_data = [
                    'id' => $channel_id,
                    'name' => $temp_data['name'],
                    'link' => $temp_data['link']
                ];
                
                if (add_required_channel($channel_data)) {
                    send_message($chat_id, "✅ کانال خصوصی «{$temp_data['name']}» با موفقیت اضافه شد!\n\n🆔 Chat ID: <code>$channel_id</code>");
                } else {
                    send_message($chat_id, "❌ این کانال قبلاً اضافه شده است.");
                }
                
                // حذف فایل موقت
                unlink($temp_file);
                set_user_state($user_id, null);
            } else {
                send_message($chat_id, "❌ خطا! لطفاً دوباره از ابتدا شروع کنید.");
                set_user_state($user_id, null);
            }
        } else {
            send_message($chat_id, "❌ لطفاً یک پیام از کانال را فوروارد کنید!\n\n(پیام باید از کانال باشد، نه از یک کاربر)");
        }
    } elseif ($state == 'waiting_for_channel_remove' && is_admin($user_id)) {
        $channel_id = trim(str_replace('@', '', $text));
        
        if (remove_required_channel($channel_id)) {
            send_message($chat_id, "✅ کانال با شناسه «$channel_id» با موفقیت حذف شد.");
        } else {
            send_message($chat_id, "❌ کانال با این شناسه در لیست وجود ندارد.");
        }
        set_user_state($user_id, null);
    } elseif (isset($message['forward_from_chat']) && is_admin($user_id) && 
              $state !== 'waiting_for_private_channel_forward' && 
              $state !== 'waiting_for_forward') {
        // اگر پیام فوروارد شده است و کاربر ادمین است (و در حالت خاصی نیست)
        $from_chat_id = $message['forward_from_chat']['id'];
        $message_id = $message['forward_from_message_id'] ?? $message['message_id'];
        $users = load_users();
        $success_count = 0;
        $fail_count = 0;

        $status_message = send_message($chat_id, "📊 در حال آماده‌سازی فوروارد همگانی...\n\n👥 تعداد کل کاربران: " . number_format(count($users)));
        if ($status_message) {
            forward_message_to_all($from_chat_id, $message_id, $chat_id, $status_message['message_id']);
            send_message($chat_id, "✅ فوروارد همگانی شروع شد.\n⏱ پیام‌ها به تدریج (هر دقیقه 100 نفر) فوروارد خواهند شد.");
        }
    } else {
        if (is_admin($user_id)) {
            // بررسی دستورات ادمین
            if ($text == '/admin') {
                $stats = get_stats();
                $admin_panel = "🎮 پنل مدیریت حرفه‌ای\n\n";
                $admin_panel .= "📊 آمار کلی:\n";
                $admin_panel .= "👥 کاربران: " . number_format($stats['user_count']) . " نفر\n";
                $admin_panel .= "🔗 لینک‌ها: " . number_format($stats['link_count']) . " عدد\n\n";
                $admin_panel .= "⚡️ دسترسی سریع به بخش‌های مختلف:";

                $reply_markup = [
                    'inline_keyboard' => [
                        [
                            ['text' => '📢 ارسال پیام همگانی', 'callback_data' => 'broadcast_menu'],
                            ['text' => '📤 فوروارد همگانی', 'callback_data' => 'forward_menu']
                        ],
                        [
                            ['text' => '🔗 مدیریت لینک‌ها', 'callback_data' => 'links_menu'],
                            ['text' => '📣 مدیریت کانال‌ها', 'callback_data' => 'channels_menu']
                        ],
                        [
                            ['text' => '🎯 مدیریت دکمه‌ها', 'callback_data' => 'buttons_menu']
                        ],
                        [
                            ['text' => '📊 گزارش آماری', 'callback_data' => 'stats_menu'],
                            ['text' => '⚙️ تنظیمات', 'callback_data' => 'settings_menu']
                        ]
                    ]
                ];
                send_message($chat_id, $admin_panel, $reply_markup);
                return;
            }
            
            // بررسی سایر دستورات ادمین
            if (substr($text, 0, 1) === '/') {
                return;
            }
            
            // پردازش لینک‌ها
            if (filter_var($text, FILTER_VALIDATE_URL) || 
                preg_match('/^(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w \.-]*)*\/?$/', $text) || 
                strpos($text, 't.me/') !== false) {
                
                $unique_id = generate_unique_id($user_id);
                add_link($unique_id, $text, $user_id);
                $protect_link = "https://t.me/" . BOT_USERNAME . "?start=" . $unique_id;
                send_message($chat_id, "🔗 لینک محافظت شده شما (60 ثانیه معتبر است):\n" . $protect_link);
            }
        }
    }
}

// پنل مدیریتی
if (isset($update['message']['text']) && $update['message']['text'] == '/admin' && is_admin($user_id)) {
    $stats = get_stats();
    $admin_panel = "🎮 پنل مدیریت حرفه‌ای\n\n";
    $admin_panel .= "📊 آمار کلی:\n";
    $admin_panel .= "👥 کاربران: " . number_format($stats['user_count']) . " نفر\n";
    $admin_panel .= "🔗 لینک‌ها: " . number_format($stats['link_count']) . " عدد\n\n";
    $admin_panel .= "⚡️ دسترسی سریع به بخش‌های مختلف:";

    $reply_markup = [
        'inline_keyboard' => [
            [
                ['text' => '📢 ارسال پیام همگانی', 'callback_data' => 'broadcast_menu'],
                ['text' => '📤 فوروارد همگانی', 'callback_data' => 'forward_menu']
            ],
            [
                ['text' => '🔗 مدیریت لینک‌ها', 'callback_data' => 'links_menu'],
                ['text' => '📣 مدیریت کانال‌ها', 'callback_data' => 'channels_menu']
            ],
            [
                ['text' => '📊 گزارش آماری', 'callback_data' => 'stats_menu'],
                ['text' => '⚙️ تنظیمات', 'callback_data' => 'settings_menu']
            ]
        ]
    ];
    send_message($chat_id, $admin_panel, $reply_markup);
}

// هندل کلیک روی دکمه‌ها
if (isset($update['callback_query'])) {
    $callback_query = $update['callback_query'];
    $chat_id = $callback_query['message']['chat']['id'];
    $user_id = $callback_query['from']['id'];
    $data = $callback_query['data'];
    $message_id = $callback_query['message']['message_id'];

    // اگر دکمه بررسی عضویت نیست، فقط ادمین‌ها دسترسی دارند
    if ($data !== 'check_membership' && !is_admin($user_id)) {
        answer_callback_query($callback_query['id'], "⛔️ شما دسترسی به این بخش ندارید!");
        exit;
    }

    switch($data) {
        case 'broadcast_menu':
            $menu = "📢 ارسال پیام همگانی\n\n";
            $menu .= "• پیام خود را برای ارسال به تمام کاربران وارد کنید.\n";
            $menu .= "• از فرمت HTML پشتیبانی می‌شود.\n";
            $menu .= "• پیام‌ها به صورت تدریجی (هر دقیقه 100 نفر) ارسال می‌شوند.";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'back_to_main']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            set_user_state($user_id, 'waiting_for_broadcast');
            break;

        case 'forward_menu':
            $menu = "📤 فوروارد همگانی\n\n";
            $menu .= "• پیام مورد نظر خود را فوروارد کنید.\n";
            $menu .= "• پیام به صورت تدریجی (هر دقیقه 100 نفر) فوروارد می‌شود.\n";
            $menu .= "• از هر نوع محتوایی پشتیبانی می‌شود.";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'back_to_main']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            set_user_state($user_id, 'waiting_for_forward');
            break;

        case 'refresh_broadcast_stats':
            answer_callback_query($callback_query['id']);
            $processed_file = __DIR__ . '/broadcast_processed.json';
            if (file_exists($processed_file)) {
                $processed_data = json_decode(file_get_contents($processed_file), true);
                if ($processed_data) {
                    $total_users = count(load_users());
                    $remaining = $total_users - count($processed_data['processed_users']);
                    $progress_text = "📊 وضعیت ارسال همگانی:\n\n";
                    $progress_text .= "👥 تعداد افراد ارسالی: " . count($processed_data['processed_users']) . "\n";
                    $progress_text .= "⏱ زمان تخمینی باقیمانده: " . ceil($remaining / 100) . " دقیقه\n\n";
                    $progress_text .= "✅ موفق: " . $processed_data['success'] . "\n";
                    $progress_text .= "❌ ناموفق: " . $processed_data['failed'] . "\n";
                    
                    $reply_markup = null;
                    if ($remaining > 0) {
                        $reply_markup = [
                            'inline_keyboard' => [
                                [['text' => '🔄 بروزرسانی آمار', 'callback_data' => 'refresh_broadcast_stats']]
                            ]
                        ];
                    }
                    
                    edit_message($chat_id, $message_id, $progress_text, $reply_markup);
                }
            }
            break;

        case 'refresh_forward_stats':
            answer_callback_query($callback_query['id']);
            $processed_file = __DIR__ . '/forward_processed.json';
            if (file_exists($processed_file)) {
                $processed_data = json_decode(file_get_contents($processed_file), true);
                if ($processed_data) {
                    $total_users = count(load_users());
                    $remaining = $total_users - count($processed_data['processed_users']);
                    $progress_text = "📊 وضعیت فوروارد همگانی:\n\n";
                    $progress_text .= "👥 تعداد افراد ارسالی: " . count($processed_data['processed_users']) . "\n";
                    $progress_text .= "⏱ زمان تخمینی باقیمانده: " . ceil($remaining / 100) . " دقیقه\n\n";
                    $progress_text .= "✅ موفق: " . $processed_data['success'] . "\n";
                    $progress_text .= "❌ ناموفق: " . $processed_data['failed'] . "\n";
                    
                    $reply_markup = null;
                    if ($remaining > 0) {
                        $reply_markup = [
                            'inline_keyboard' => [
                                [['text' => '🔄 بروزرسانی آمار', 'callback_data' => 'refresh_forward_stats']]
                            ]
                        ];
                    }
                    
                    edit_message($chat_id, $message_id, $progress_text, $reply_markup);
                }
            }
            break;

        case 'links_menu':
            $pagination = get_links_paginated(1);
            $menu = "🔗 مدیریت لینک‌ها\n\n";
            
            if (empty($pagination['links'])) {
                $menu .= "❌ هیچ لینکی موجود نیست.";
            } else {
                $menu .= "📋 لیست آخرین لینک‌ها (صفحه 1 از {$pagination['total_pages']}):\n\n";
                foreach ($pagination['links'] as $unique_id => $link) {
                    $menu .= "🔹 شناسه: " . $unique_id . "\n";
                    $menu .= "🔸 لینک: " . $link['original_link'] . "\n";
                    $menu .= "👤 کاربر: " . $link['user_id'] . "\n";
                    $menu .= "📅 تاریخ: " . $link['created_at'] . "\n\n";
                }
            }

            $keyboard = [];
            if ($pagination['total_pages'] > 1) {
                $keyboard[] = [
                    ['text' => '◀️ قبلی', 'callback_data' => 'links_prev_1'],
                    ['text' => '▶️ بعدی', 'callback_data' => 'links_next_2']
                ];
            }
            $keyboard[] = [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'back_to_main']];
            
            $reply_markup = ['inline_keyboard' => $keyboard];
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;
            
        // هندل دکمه‌های قبلی و بعدی در مدیریت لینک‌ها
        case (preg_match('/^links_prev_(\d+)$/', $data, $matches) ? true : false):
            $current_page = intval($matches[1]);
            $prev_page = max(1, $current_page - 1);
            $pagination = get_links_paginated($prev_page);
            
            $menu = "🔗 مدیریت لینک‌ها\n\n";
            if (empty($pagination['links'])) {
                $menu .= "❌ هیچ لینکی موجود نیست.";
            } else {
                $menu .= "📋 لیست آخرین لینک‌ها (صفحه $prev_page از {$pagination['total_pages']}):\n\n";
                foreach ($pagination['links'] as $unique_id => $link) {
                    $menu .= "🔹 شناسه: " . $unique_id . "\n";
                    $menu .= "🔸 لینک: " . $link['original_link'] . "\n";
                    $menu .= "👤 کاربر: " . $link['user_id'] . "\n";
                    $menu .= "📅 تاریخ: " . $link['created_at'] . "\n\n";
                }
            }
            
            $keyboard = [];
            if ($pagination['total_pages'] > 1) {
                $keyboard[] = [];
                if ($prev_page > 1) {
                    $keyboard[0][] = ['text' => '◀️ قبلی', 'callback_data' => 'links_prev_' . ($prev_page - 1)];
                }
                if ($prev_page < $pagination['total_pages']) {
                    $keyboard[0][] = ['text' => '▶️ بعدی', 'callback_data' => 'links_next_' . ($prev_page + 1)];
                }
            }
            $keyboard[] = [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'back_to_main']];
            
            $reply_markup = ['inline_keyboard' => $keyboard];
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;
            
        case (preg_match('/^links_next_(\d+)$/', $data, $matches) ? true : false):
            $current_page = intval($matches[1]);
            $pagination = get_links_paginated($current_page);
            
            $menu = "🔗 مدیریت لینک‌ها\n\n";
            if (empty($pagination['links'])) {
                $menu .= "❌ هیچ لینکی موجود نیست.";
            } else {
                $menu .= "📋 لیست آخرین لینک‌ها (صفحه $current_page از {$pagination['total_pages']}):\n\n";
                foreach ($pagination['links'] as $unique_id => $link) {
                    $menu .= "🔹 شناسه: " . $unique_id . "\n";
                    $menu .= "🔸 لینک: " . $link['original_link'] . "\n";
                    $menu .= "👤 کاربر: " . $link['user_id'] . "\n";
                    $menu .= "📅 تاریخ: " . $link['created_at'] . "\n\n";
                }
            }
            
            $keyboard = [];
            if ($pagination['total_pages'] > 1) {
                $keyboard[] = [];
                if ($current_page > 1) {
                    $keyboard[0][] = ['text' => '◀️ قبلی', 'callback_data' => 'links_prev_' . ($current_page - 1)];
                }
                if ($current_page < $pagination['total_pages']) {
                    $keyboard[0][] = ['text' => '▶️ بعدی', 'callback_data' => 'links_next_' . ($current_page + 1)];
                }
            }
            $keyboard[] = [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'back_to_main']];
            
            $reply_markup = ['inline_keyboard' => $keyboard];
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'channels_menu':
            $channels = load_channels();
            $menu = "📣 مدیریت کانال‌های اجباری\n\n";
            $menu .= "📋 لیست کانال‌های فعلی:\n\n";
            
            if (empty($channels['required_channels'])) {
                $menu .= "❌ هیچ کانالی ثبت نشده است.\n\n";
            } else {
                foreach ($channels['required_channels'] as $channel) {
                    // پشتیبانی از ساختار قدیمی و جدید
                    if (is_string($channel)) {
                    $menu .= "• @" . $channel . "\n";
                    } else {
                        $type = (strpos($channel['id'], '-') === 0 || is_numeric($channel['id'])) ? "🔒 خصوصی" : "🌐 عمومی";
                        $menu .= "• " . ($channel['name'] ?? $channel['id']) . " (" . $type . ")\n";
                    }
                }
            }
            
            $menu .= "\n💡 نکته: برای افزودن کانال خصوصی، Chat ID کانال را وارد کنید.";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '➕ افزودن کانال', 'callback_data' => 'add_channel'],
                        ['text' => '➖ حذف کانال', 'callback_data' => 'remove_channel']
                    ],
                    [['text' => '❓ راهنما', 'callback_data' => 'channel_help']],
                    [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'back_to_main']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'stats_menu':
        case 'refresh_stats':
            $stats = get_stats();
            $menu = "📊 گزارش آماری\n\n";
            $menu .= "👥 تعداد کل کاربران: " . number_format($stats['user_count']) . "\n";
            $menu .= "🔗 تعداد کل لینک‌ها: " . number_format($stats['link_count']) . "\n";
            // اضافه کردن آمار بیشتر در اینجا
            
            $reply_markup = [
                'inline_keyboard' => [
                    [['text' => '🔄 بروزرسانی آمار', 'callback_data' => 'refresh_stats']],
                    [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'back_to_main']]
                ]
            ];
            
            if ($data == 'refresh_stats') {
                answer_callback_query($callback_query['id'], "✅ آمار به‌روزرسانی شد");
            }
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'settings_menu':
            $current_delete_time = get_auto_delete_time();
            $menu = "⚙️ تنظیمات\n\n";
            $menu .= "• تنظیمات عمومی ربات\n";
            $menu .= "• مدیریت دسترسی‌ها\n";
            $menu .= "• تنظیمات پیشرفته\n\n";
            $menu .= "⏱ زمان حذف خودکار پیام: <b>" . $current_delete_time . " ثانیه</b>";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '✏️ تنظیم متن استارت', 'callback_data' => 'start_message_settings']
                    ],
                    [
                        ['text' => '🔐 تنظیم متن جوین اجباری', 'callback_data' => 'forced_join_message_settings']
                    ],
                    [
                        ['text' => '⏱ تنظیم زمان حذف خودکار', 'callback_data' => 'auto_delete_settings']
                    ],
                    [
                        ['text' => '🤖 تنظیمات ربات', 'callback_data' => 'bot_settings'],
                        ['text' => '👥 دسترسی‌ها', 'callback_data' => 'access_settings']
                    ],
                    [['text' => '⚡️ تنظیمات پیشرفته', 'callback_data' => 'advanced_settings']],
                    [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'back_to_main']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'bot_settings':
            $menu = "🤖 تنظیمات ربات\n\n";
            $menu .= "این بخش در حال توسعه است...";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [['text' => '🔙 بازگشت', 'callback_data' => 'settings_menu']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'access_settings':
            $menu = "👥 تنظیمات دسترسی‌ها\n\n";
            $menu .= "این بخش در حال توسعه است...";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [['text' => '🔙 بازگشت', 'callback_data' => 'settings_menu']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'advanced_settings':
            $menu = "⚡️ تنظیمات پیشرفته\n\n";
            $menu .= "این بخش در حال توسعه است...";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [['text' => '🔙 بازگشت', 'callback_data' => 'settings_menu']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'start_message_settings':
            $start_data = get_start_message();
            $menu = "✏️ تنظیمات پیشرفته متن استارت\n\n";
            
            // نمایش وضعیت فعلی
            if ($start_data['type'] === 'forward') {
                $menu .= "📌 نوع فعلی: <b>فوروارد پیام</b>\n";
                $menu .= "🆔 Chat ID: <code>" . $start_data['forward_from_chat_id'] . "</code>\n";
                $menu .= "🆔 Message ID: <code>" . $start_data['forward_message_id'] . "</code>\n\n";
            } else {
                $menu .= "📌 نوع فعلی: <b>متن/عکس سفارشی</b>\n\n";
                
                if (!empty($start_data['photo'])) {
                    $menu .= "🖼 عکس: ✅ دارد\n";
                }
                
                $message_preview = $start_data['message'] ?? '';
                if (strlen($message_preview) > 100) {
                    $message_preview = mb_substr($message_preview, 0, 100) . "...";
                }
                $menu .= "📝 متن: " . ($message_preview ?: "بدون متن") . "\n\n";
                
                if (!empty($start_data['inline_buttons'])) {
                    $menu .= "🔘 دکمه‌های شیشه‌ای: " . count($start_data['inline_buttons']) . " عدد\n";
                }
            }
            
            $menu .= "\n💡 از این منو می‌توانید متن استارت را با قابلیت‌های زیر تنظیم کنید:\n";
            $menu .= "• متن با لینک‌های کلیک‌دار (HTML)\n";
            $menu .= "• عکس + متن + دکمه‌های شیشه‌ای";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '📝 تنظیم متن ساده', 'callback_data' => 'set_start_text'],
                        ['text' => '🖼 تنظیم با عکس', 'callback_data' => 'set_start_photo']
                    ],
                    [
                        ['text' => '📤 فوروارد پیام', 'callback_data' => 'set_start_forward']
                    ],
                    [
                        ['text' => '🗑 بازگشت به پیش‌فرض', 'callback_data' => 'delete_start_message']
                    ],
                    [['text' => '🔙 بازگشت', 'callback_data' => 'settings_menu']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'set_start_text':
            set_user_state($user_id, 'waiting_for_start_text');
            answer_callback_query($callback_query['id'], "✅ منتظر متن هستم...");
            
            $msg = "📝 <b>تنظیم متن استارت - مرحله 1 از 2</b>\n\n";
            $msg .= "متن پیام استارت را ارسال کنید.\n\n";
            $msg .= "💡 <b>نکات مهم:</b>\n";
            $msg .= "• از تگ‌های HTML برای فرمت‌دهی استفاده کنید:\n";
            $msg .= "  - <code>&lt;b&gt;متن&lt;/b&gt;</code> برای بولد\n";
            $msg .= "  - <code>&lt;i&gt;متن&lt;/i&gt;</code> برای ایتالیک\n";
            $msg .= "  - <code>&lt;a href=\"لینک\"&gt;متن&lt;/a&gt;</code> برای لینک متن‌دار\n\n";
            $msg .= "📌 مثال:\n";
            $msg .= "<code>سلام 👋\nبرای دانلود &lt;a href=\"https://t.me/channel\"&gt;اینجا کلیک کنید&lt;/a&gt;</code>";
            
            send_message($chat_id, $msg);
            break;
        
        case 'set_start_photo':
            set_user_state($user_id, 'waiting_for_start_photo');
            answer_callback_query($callback_query['id'], "✅ منتظر عکس هستم...");
            
            $msg = "🖼 <b>تنظیم استارت با عکس - مرحله 1 از 3</b>\n\n";
            $msg .= "لطفاً عکس مورد نظر را ارسال کنید.\n\n";
            $msg .= "💡 این عکس همراه با متن و دکمه‌های شیشه‌ای نمایش داده می‌شود.";
            
            send_message($chat_id, $msg);
            break;
        

        case 'delete_start_message':
            $default_data = [
                'type' => 'text',
                'message' => "👋 سلام! لینک خود را ارسال کنید تا محافظت شود.",
                'photo' => null,
                'inline_buttons' => [],
                'forward_from_chat_id' => null,
                'forward_message_id' => null
            ];
            save_start_message($default_data);
            answer_callback_query($callback_query['id'], "✅ متن استارت به حالت پیش‌فرض برگشت.", true);
            
            // نمایش مجدد منوی تنظیمات
            $menu = "✏️ تنظیمات پیشرفته متن استارت\n\n";
            $menu .= "📌 نوع فعلی: <b>متن/عکس سفارشی</b>\n\n";
            $menu .= "📝 متن: " . $default_data['message'] . "\n\n";
            $menu .= "\n💡 از این منو می‌توانید متن استارت را با قابلیت‌های زیر تنظیم کنید:\n";
            $menu .= "• متن با لینک‌های کلیک‌دار (HTML)\n";
            $menu .= "• عکس + متن + دکمه‌های شیشه‌ای";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '📝 تنظیم متن ساده', 'callback_data' => 'set_start_text'],
                        ['text' => '🖼 تنظیم با عکس', 'callback_data' => 'set_start_photo']
                    ],
                    [
                        ['text' => '📤 فوروارد پیام', 'callback_data' => 'set_start_forward']
                    ],
                    [
                        ['text' => '🗑 بازگشت به پیش‌فرض', 'callback_data' => 'delete_start_message']
                    ],
                    [['text' => '🔙 بازگشت', 'callback_data' => 'settings_menu']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'forced_join_message_settings':
            $current_message = get_forced_join_message();
            $menu = "🔐 تنظیم متن جوین اجباری\n\n";
            $menu .= "متن فعلی:\n\n";
            $menu .= $current_message . "\n\n";
            $menu .= "این متن زمانی که کاربر در کانال‌های اجباری عضو نباشد نمایش داده می‌شود.\n\n";
            $menu .= "برای تنظیم روی دکمه (⚙️ تنظیم متن) ، برای حذف روی دکمه (🗑 حذف متن) که با این کار متن پیش فرض نمایش داده میشه و برای بازگشت روی (🔙 بازگشت) بزنید.";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '⚙️ تنظیم متن', 'callback_data' => 'set_forced_join_message'],
                        ['text' => '🗑 حذف متن', 'callback_data' => 'delete_forced_join_message']
                    ],
                    [['text' => '🔙 بازگشت', 'callback_data' => 'settings_menu']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'set_forced_join_message':
            set_user_state($user_id, 'waiting_for_forced_join_message');
            answer_callback_query($callback_query['id'], "✅ منتظر متن جدید هستم...");
            $menu = "🔐 لطفاً متن جدید جوین اجباری را ارسال کنید:";
            send_message($chat_id, $menu);
            break;

        case 'delete_forced_join_message':
            $default_message = "⚠️ لطفاً ابتدا در کانال‌های زیر عضو شوید:\n\n";
            save_forced_join_message($default_message);
            answer_callback_query($callback_query['id'], "✅ متن جوین اجباری به حالت پیش‌فرض برگشت.", true);
            
            // نمایش مجدد منوی تنظیم متن جوین اجباری
            $menu = "🔐 تنظیم متن جوین اجباری\n\n";
            $menu .= "متن فعلی:\n\n";
            $menu .= $default_message . "\n\n";
            $menu .= "این متن زمانی که کاربر در کانال‌های اجباری عضو نباشد نمایش داده می‌شود.\n\n";
            $menu .= "برای تنظیم روی دکمه (⚙️ تنظیم متن) ، برای حذف روی دکمه (🗑 حذف متن) که با این کار متن پیش فرض نمایش داده میشه و برای بازگشت روی (🔙 بازگشت) بزنید.";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '⚙️ تنظیم متن', 'callback_data' => 'set_forced_join_message'],
                        ['text' => '🗑 حذف متن', 'callback_data' => 'delete_forced_join_message']
                    ],
                    [['text' => '🔙 بازگشت', 'callback_data' => 'settings_menu']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'auto_delete_settings':
            $current_time = get_auto_delete_time();
            $minutes = floor($current_time / 60);
            $seconds = $current_time % 60;
            $time_display = $minutes > 0 ? "$minutes دقیقه و $seconds ثانیه" : "$seconds ثانیه";
            
            $menu = "⏱ تنظیم زمان حذف خودکار پیام\n\n";
            $menu .= "⏰ زمان فعلی: <b>$time_display</b>\n\n";
            $menu .= "پیام‌های موقت (مثل پیام دریافت فایل) بعد از این مدت به صورت خودکار حذف می‌شوند.\n\n";
            $menu .= "🎯 یک زمان را انتخاب کنید یا مقدار دلخواه خود را وارد کنید:";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '⚡️ 10 ثانیه', 'callback_data' => 'set_delete_time_10'],
                        ['text' => '30 ثانیه', 'callback_data' => 'set_delete_time_30']
                    ],
                    [
                        ['text' => '🕐 1 دقیقه', 'callback_data' => 'set_delete_time_60'],
                        ['text' => '2 دقیقه', 'callback_data' => 'set_delete_time_120']
                    ],
                    [
                        ['text' => '3 دقیقه', 'callback_data' => 'set_delete_time_180'],
                        ['text' => '5 دقیقه ⏰', 'callback_data' => 'set_delete_time_300']
                    ],
                    [
                        ['text' => '✏️ وارد کردن مقدار دلخواه', 'callback_data' => 'set_custom_delete_time']
                    ],
                    [['text' => '🔙 بازگشت', 'callback_data' => 'settings_menu']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case (preg_match('/^set_delete_time_(\d+)$/', $data, $matches) ? true : false):
            $time_seconds = intval($matches[1]);
            save_auto_delete_time($time_seconds);
            
            $minutes = floor($time_seconds / 60);
            $seconds = $time_seconds % 60;
            $time_display = $minutes > 0 ? "$minutes دقیقه و $seconds ثانیه" : "$seconds ثانیه";
            
            answer_callback_query($callback_query['id'], "✅ زمان حذف خودکار به $time_display تنظیم شد", true);
            
            // نمایش مجدد منو با مقدار جدید
            $current_time = get_auto_delete_time();
            $minutes = floor($current_time / 60);
            $seconds = $current_time % 60;
            $time_display = $minutes > 0 ? "$minutes دقیقه و $seconds ثانیه" : "$seconds ثانیه";
            
            $menu = "⏱ تنظیم زمان حذف خودکار پیام\n\n";
            $menu .= "⏰ زمان فعلی: <b>$time_display</b>\n\n";
            $menu .= "پیام‌های موقت (مثل پیام دریافت فایل) بعد از این مدت به صورت خودکار حذف می‌شوند.\n\n";
            $menu .= "🎯 یک زمان را انتخاب کنید یا مقدار دلخواه خود را وارد کنید:";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '⚡️ 10 ثانیه', 'callback_data' => 'set_delete_time_10'],
                        ['text' => '30 ثانیه', 'callback_data' => 'set_delete_time_30']
                    ],
                    [
                        ['text' => '🕐 1 دقیقه', 'callback_data' => 'set_delete_time_60'],
                        ['text' => '2 دقیقه', 'callback_data' => 'set_delete_time_120']
                    ],
                    [
                        ['text' => '3 دقیقه', 'callback_data' => 'set_delete_time_180'],
                        ['text' => '5 دقیقه ⏰', 'callback_data' => 'set_delete_time_300']
                    ],
                    [
                        ['text' => '✏️ وارد کردن مقدار دلخواه', 'callback_data' => 'set_custom_delete_time']
                    ],
                    [['text' => '🔙 بازگشت', 'callback_data' => 'settings_menu']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'set_custom_delete_time':
            set_user_state($user_id, 'waiting_for_delete_time');
            answer_callback_query($callback_query['id'], "✅ منتظر زمان دلخواه هستم...");
            $menu = "⏱ لطفاً زمان حذف خودکار را به ثانیه وارد کنید:\n\n";
            $menu .= "📌 حداقل: 10 ثانیه\n";
            $menu .= "📌 حداکثر: 300 ثانیه (5 دقیقه)\n\n";
            $menu .= "مثال: <code>45</code> (برای 45 ثانیه)";
            send_message($chat_id, $menu);
            break;

        case 'back_to_main':
            $stats = get_stats();
            $admin_panel = "🎮 پنل مدیریت حرفه‌ای\n\n";
            $admin_panel .= "📊 آمار کلی:\n";
            $admin_panel .= "👥 کاربران: " . number_format($stats['user_count']) . " نفر\n";
            $admin_panel .= "🔗 لینک‌ها: " . number_format($stats['link_count']) . " عدد\n\n";
            $admin_panel .= "⚡️ دسترسی سریع به بخش‌های مختلف:";

            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '📢 ارسال پیام همگانی', 'callback_data' => 'broadcast_menu'],
                        ['text' => '📤 فوروارد همگانی', 'callback_data' => 'forward_menu']
                    ],
                    [
                        ['text' => '🔗 مدیریت لینک‌ها', 'callback_data' => 'links_menu'],
                        ['text' => '📣 مدیریت کانال‌ها', 'callback_data' => 'channels_menu']
                    ],
                    [
                        ['text' => '🎯 مدیریت دکمه‌ها', 'callback_data' => 'buttons_menu']
                    ],
                    [
                        ['text' => '📊 گزارش آماری', 'callback_data' => 'stats_menu'],
                        ['text' => '⚙️ تنظیمات', 'callback_data' => 'settings_menu']
                    ]
                ]
            ];
            edit_message($chat_id, $message_id, $admin_panel, $reply_markup);
            break;

        case 'check_membership':
            if (check_user_membership($user_id)) {
                // Get unique_id from user state
                $state = get_user_state($user_id);
                $unique_id = null;
                
                if (strpos($state, 'waiting_verification_') === 0) {
                    $unique_id = substr($state, strlen('waiting_verification_'));
                }
                
                if ($unique_id) {
                    $original_link = get_link($unique_id);
                    if ($original_link) {
                        // Delete the old message with channel buttons
                        delete_message($chat_id, $message_id);
                        
                        // Send single message with verification and download button
                        $reply_markup = [
                            'inline_keyboard' => [
                                [['text' => 'دریافت فایل', 'url' => $original_link]]
                            ]
                        ];
                        send_temporary_message($chat_id, "برای دریافت فایل روی دکمه زیر کلیک کنید 👇", $reply_markup);
                    } else {
                        send_message($chat_id, "❌ لینک یافت نشد یا منقضی شده است.");
                    }
                } else {
                    // For regular /start command
                    delete_message($chat_id, $message_id);
                    $keyboard = get_custom_buttons_keyboard();
                    send_start_message($chat_id, $keyboard);
                }
                
                // Clear user state after processing
                set_user_state($user_id, null);
            } else {
                answer_callback_query($callback_query['id'], "❌ لطفاً ابتدا در تمام کانال‌ها عضو شوید و سپس دوباره تلاش کنید.", true);
            }
            break;

        case 'channel_help':
            $help_menu = "📖 راهنمای افزودن کانال\n\n";
            $help_menu .= "🌐 <b>کانال عمومی:</b>\n";
            $help_menu .= "1. روی «افزودن کانال» کلیک کنید\n";
            $help_menu .= "2. «کانال عمومی» را انتخاب کنید\n";
            $help_menu .= "3. نام نمایشی کانال را وارد کنید (مثل: کانال اسپانسر)\n";
            $help_menu .= "4. نام کاربری کانال را بدون @ ارسال کنید (مثل: mychannel)\n";
            $help_menu .= "5. تمام! ✅\n\n";
            
            $help_menu .= "🔒 <b>کانال خصوصی:</b>\n";
            $help_menu .= "1. روی «افزودن کانال» کلیک کنید\n";
            $help_menu .= "2. «کانال خصوصی» را انتخاب کنید\n";
            $help_menu .= "3. نام نمایشی کانال را وارد کنید (مثل: کانال VIP)\n";
            $help_menu .= "4. لینک دعوت کانال را ارسال کنید\n";
            $help_menu .= "5. یک پیام از کانال را فوروارد کنید\n";
            $help_menu .= "6. تمام! ✅\n\n";
            
            $help_menu .= "📎 <b>لینک دعوت کانال خصوصی:</b>\n";
            $help_menu .= "تنظیمات کانال > Invite Links > لینک را کپی کنید\n\n";
            
            $help_menu .= "⚠️ <b>نکته مهم:</b>\n";
            $help_menu .= "ربات باید Admin کانال خصوصی باشد!";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [['text' => '🔙 بازگشت', 'callback_data' => 'channels_menu']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $help_menu, $reply_markup);
            break;

                case 'add_channel':
            answer_callback_query($callback_query['id'], "✅ کانال عمومی یا خصوصی؟");
            
            $add_msg = "➕ <b>افزودن کانال جدید</b>\n\n";
            $add_msg .= "نوع کانال را انتخاب کنید:";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '🌐 کانال عمومی', 'callback_data' => 'add_public_channel'],
                        ['text' => '🔒 کانال خصوصی', 'callback_data' => 'add_private_channel']
                    ],
                    [['text' => '🔙 بازگشت', 'callback_data' => 'channels_menu']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $add_msg, $reply_markup);
            break;

        case 'add_public_channel':
            set_user_state($user_id, 'waiting_for_public_channel_name');
            answer_callback_query($callback_query['id'], "✅ شروع افزودن کانال عمومی...");
            
            $add_msg = "➕ <b>افزودن کانال عمومی - مرحله 1 از 2</b>\n\n";
            $add_msg .= "📝 نام نمایشی کانال را وارد کنید:\n";
            $add_msg .= "(این نام روی دکمه شیشه‌ای نمایش داده می‌شود)\n\n";
            $add_msg .= "مثال: <code>کانال اسپانسر</code>";
            
            send_message($chat_id, $add_msg);
            break;

        case 'add_private_channel':
            set_user_state($user_id, 'waiting_for_private_channel_name');
            answer_callback_query($callback_query['id'], "✅ شروع افزودن کانال خصوصی...");
            
            $add_msg = "➕ <b>افزودن کانال خصوصی - مرحله 1 از 3</b>\n\n";
            $add_msg .= "📝 نام کانال را وارد کنید:\n";
            $add_msg .= "(این نام روی دکمه شیشه‌ای نمایش داده می‌شود)\n\n";
            $add_msg .= "مثال: <code>کانال اختصاصی من</code>";
            
            send_message($chat_id, $add_msg);
            break;

        case 'remove_channel':
        set_user_state($user_id, 'waiting_for_channel_remove');
            answer_callback_query($callback_query['id'], "✅ منتظر شناسه کانال هستم...");
            
            $remove_msg = "➖ <b>حذف کانال</b>\n\n";
            $remove_msg .= "🌐 برای کانال عمومی: نام کاربری بدون @\n";
            $remove_msg .= "🔒 برای کانال خصوصی: Chat ID\n\n";
            
            $remove_msg .= "📋 لیست کانال‌های فعلی:\n";
            
            $channels = load_channels();
            if (!empty($channels['required_channels'])) {
                foreach ($channels['required_channels'] as $channel) {
                    if (is_string($channel)) {
                        $remove_msg .= "• <code>$channel</code>\n";
                    } else {
                        $remove_msg .= "• <code>" . $channel['id'] . "</code> - " . ($channel['name'] ?? 'بدون نام') . "\n";
                    }
                }
            }
            
            send_message($chat_id, $remove_msg);
            break;

        case 'buttons_menu':
            $buttons = load_custom_buttons();
            $menu = "🎯 مدیریت دکمه‌های سفارشی\n\n";
            $menu .= "📋 لیست دکمه‌های فعلی:\n\n";
            
            if (empty($buttons)) {
                $menu .= "❌ هیچ دکمه‌ای ثبت نشده است.\n\n";
            } else {
                foreach ($buttons as $button) {
                    $has_inline = isset($button['inline_buttons']) && !empty($button['inline_buttons']);
                    $inline_status = $has_inline ? "✅ با دکمه شیشه‌ای" : "❌ بدون دکمه شیشه‌ای";
                    $menu .= "• " . $button['name'] . " ($inline_status)\n";
                }
            }
            
            $menu .= "\n💡 نکته: دکمه‌ها برای کاربران عادی نمایش داده می‌شوند.";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '➕ افزودن دکمه', 'callback_data' => 'add_button'],
                        ['text' => '➖ حذف دکمه', 'callback_data' => 'remove_button']
                    ],
                    [['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'back_to_main']]
                ]
            ];
            
            edit_message($chat_id, $message_id, $menu, $reply_markup);
            break;

        case 'add_button':
            set_user_state($user_id, 'waiting_for_button_name');
            answer_callback_query($callback_query['id'], "✅ شروع افزودن دکمه...");
            
            $add_msg = "➕ <b>افزودن دکمه سفارشی - مرحله 1 از 4</b>\n\n";
            $add_msg .= "📝 نام دکمه را وارد کنید:\n";
            $add_msg .= "(این نام روی دکمه نمایش داده می‌شود)\n\n";
            $add_msg .= "مثال: <code>سریال وحشی</code>";
            
            send_message($chat_id, $add_msg);
            break;

        case 'remove_button':
            $buttons = load_custom_buttons();
            
            if (empty($buttons)) {
                answer_callback_query($callback_query['id'], "❌ هیچ دکمه‌ای برای حذف وجود ندارد!", true);
                break;
            }
            
            set_user_state($user_id, 'waiting_for_button_remove');
            answer_callback_query($callback_query['id'], "✅ منتظر نام دکمه هستم...");
            
            $remove_msg = "➖ <b>حذف دکمه سفارشی</b>\n\n";
            $remove_msg .= "📋 لیست دکمه‌های فعلی:\n\n";
            
            foreach ($buttons as $button) {
                $remove_msg .= "• <code>" . $button['name'] . "</code>\n";
            }
            
            $remove_msg .= "\n✏️ نام دکمه‌ای که می‌خواهید حذف کنید را وارد کنید:";
            
            send_message($chat_id, $remove_msg);
            break;

        case 'start_add_inline_yes':
            answer_callback_query($callback_query['id'], "✅ آماده دریافت دکمه‌های شیشه‌ای...");
            set_user_state($user_id, 'waiting_for_start_inline_data');
            
            $temp_file = __DIR__ . '/temp_start_' . $user_id . '.json';
            if (file_exists($temp_file)) {
                $msg = "🔘 <b>افزودن دکمه‌های شیشه‌ای</b>\n\n";
                $msg .= "📝 حالا دکمه‌های شیشه‌ای را وارد کنید:\n\n";
                $msg .= "<b>فرمت:</b>\n";
                $msg .= "<code>متن دکمه | لینک</code>\n\n";
                $msg .= "📌 <b>مثال:</b>\n";
                $msg .= "<code>دانلود مستقیم | https://t.me/+RGNpM2i7ZjAyMDI5\n";
                $msg .= "کانال ما | https://t.me/mychannel\n";
                $msg .= "گروه پشتیبانی | https://t.me/support</code>\n\n";
                $msg .= "💡 هر خط یک دکمه شیشه‌ای می‌شود.";
                
                send_message($chat_id, $msg);
            } else {
                send_message($chat_id, "❌ خطا! لطفاً دوباره از ابتدا شروع کنید.");
                set_user_state($user_id, null);
            }
            break;
        
        case 'start_add_inline_no':
            answer_callback_query($callback_query['id'], "✅ در حال ذخیره...");
            
            $temp_file = __DIR__ . '/temp_start_' . $user_id . '.json';
            if (file_exists($temp_file)) {
                $temp_data = json_decode(file_get_contents($temp_file), true);
                
                // ساخت داده نهایی بدون inline buttons
                $start_data = [
                    'type' => 'text',
                    'message' => $temp_data['message'] ?? "👋 سلام!",
                    'photo' => $temp_data['photo'] ?? null,
                    'inline_buttons' => [],
                    'forward_from_chat_id' => null,
                    'forward_message_id' => null
                ];
                
                // ذخیره
                save_start_message($start_data);
                
                send_message($chat_id, "✅ متن استارت با موفقیت تنظیم شد!\n\n🎯 پیام استارت برای کاربران نمایش داده می‌شود.");
                
                // حذف فایل موقت
                unlink($temp_file);
                set_user_state($user_id, null);
            } else {
                send_message($chat_id, "❌ خطا! لطفاً دوباره از ابتدا شروع کنید.");
                set_user_state($user_id, null);
            }
            break;
        
        case 'button_add_inline_yes':
            answer_callback_query($callback_query['id'], "✅ آماده دریافت دکمه‌های شیشه‌ای...");
            set_user_state($user_id, 'waiting_for_button_inline_data');
            
            $temp_file = __DIR__ . '/temp_button_' . $user_id . '.json';
            if (file_exists($temp_file)) {
                $temp_data = json_decode(file_get_contents($temp_file), true);
                
                $msg = "➕ <b>افزودن دکمه سفارشی - مرحله 4 از 4</b>\n\n";
                $msg .= "✅ نام دکمه: <b>" . $temp_data['name'] . "</b>\n";
                $msg .= "✅ محتوا ثبت شد\n\n";
                $msg .= "📝 حالا دکمه‌های شیشه‌ای را وارد کنید:\n\n";
                $msg .= "<b>فرمت:</b>\n";
                $msg .= "<code>متن دکمه | لینک</code>\n\n";
                $msg .= "📌 <b>مثال:</b>\n";
                $msg .= "<code>دانلود سریال | https://t.me/+RGNpM2i7ZjAyMDI5\n";
                $msg .= "کانال ما | https://t.me/mychannel</code>\n\n";
                $msg .= "💡 هر خط یک دکمه شیشه‌ای می‌شود.";
                
                send_message($chat_id, $msg);
            } else {
                send_message($chat_id, "❌ خطا! لطفاً دوباره از ابتدا شروع کنید.");
                set_user_state($user_id, null);
            }
            break;

        case 'button_add_inline_no':
            answer_callback_query($callback_query['id'], "✅ در حال ذخیره...");
            
            $temp_file = __DIR__ . '/temp_button_' . $user_id . '.json';
            if (file_exists($temp_file)) {
                $temp_data = json_decode(file_get_contents($temp_file), true);
                
                // ذخیره دکمه بدون inline buttons
                add_custom_button($temp_data);
                
                send_message($chat_id, "✅ دکمه «{$temp_data['name']}» با موفقیت اضافه شد!\n\n🎯 دکمه برای کاربران نمایش داده می‌شود.");
                
                // حذف فایل موقت
                unlink($temp_file);
                set_user_state($user_id, null);
            } else {
                send_message($chat_id, "❌ خطا! لطفاً دوباره از ابتدا شروع کنید.");
                set_user_state($user_id, null);
            }
            break;
    }
}

// هندل پیام‌های معمولی برای تنظیم متن استارت (متن ساده)
if (isset($update['message']) && $state == 'waiting_for_start_text' && is_admin($user_id)) {
    $text = trim($update['message']['text'] ?? '');
    if ($text) {
        // ذخیره متن در فایل موقت
        $temp_file = __DIR__ . '/temp_start_' . $user_id . '.json';
        $temp_data = ['message' => $text];
        file_put_contents($temp_file, json_encode($temp_data, JSON_UNESCAPED_UNICODE));
        
        set_user_state($user_id, 'waiting_for_start_inline_choice');
        
        $msg = "📝 <b>تنظیم متن استارت - مرحله 2 از 2</b>\n\n";
        $msg .= "✅ متن ذخیره شد.\n\n";
        $msg .= "🔘 آیا می‌خواهید دکمه‌های شیشه‌ای (لینک‌دار) به این پیام اضافه کنید؟";
        
        $reply_markup = [
            'inline_keyboard' => [
                [
                    ['text' => '✅ بله، اضافه کن', 'callback_data' => 'start_add_inline_yes'],
                    ['text' => '❌ نه، همین کافیه', 'callback_data' => 'start_add_inline_no']
                ]
            ]
        ];
        
        send_message($chat_id, $msg, $reply_markup);
    }
    exit;
}

// هندل پیام‌های معمولی برای تنظیم عکس استارت
if (isset($update['message']) && $state == 'waiting_for_start_photo' && is_admin($user_id)) {
    $photo = null;
    
    if (isset($update['message']['photo'])) {
        // دریافت بزرگترین سایز عکس
        $photos = $update['message']['photo'];
        $photo = end($photos)['file_id'];
    }
    
    if ($photo) {
        // ذخیره photo در فایل موقت
        $temp_file = __DIR__ . '/temp_start_' . $user_id . '.json';
        $temp_data = ['photo' => $photo];
        file_put_contents($temp_file, json_encode($temp_data, JSON_UNESCAPED_UNICODE));
        
        set_user_state($user_id, 'waiting_for_start_photo_caption');
        
        $msg = "🖼 <b>تنظیم استارت با عکس - مرحله 2 از 3</b>\n\n";
        $msg .= "✅ عکس دریافت شد.\n\n";
        $msg .= "📝 حالا متن (کپشن) عکس را ارسال کنید:\n\n";
        $msg .= "💡 می‌توانید از تگ‌های HTML برای لینک متن‌دار استفاده کنید:\n";
        $msg .= "<code>&lt;a href=\"لینک\"&gt;متن&lt;/a&gt;</code>";
        
        send_message($chat_id, $msg);
    } else {
        send_message($chat_id, "❌ لطفاً یک عکس ارسال کنید!");
    }
    exit;
}

// هندل دریافت کپشن عکس
if (isset($update['message']) && $state == 'waiting_for_start_photo_caption' && is_admin($user_id)) {
    $caption = trim($update['message']['text'] ?? '');
    if ($caption) {
        // خواندن عکس از فایل موقت
        $temp_file = __DIR__ . '/temp_start_' . $user_id . '.json';
        if (file_exists($temp_file)) {
            $temp_data = json_decode(file_get_contents($temp_file), true);
            $temp_data['message'] = $caption;
            file_put_contents($temp_file, json_encode($temp_data, JSON_UNESCAPED_UNICODE));
            
            set_user_state($user_id, 'waiting_for_start_inline_choice');
            
            $msg = "🖼 <b>تنظیم استارت با عکس - مرحله 3 از 3</b>\n\n";
            $msg .= "✅ متن دریافت شد.\n\n";
            $msg .= "🔘 آیا می‌خواهید دکمه‌های شیشه‌ای (لینک‌دار) به این پیام اضافه کنید؟";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '✅ بله، اضافه کن', 'callback_data' => 'start_add_inline_yes'],
                        ['text' => '❌ نه، همین کافیه', 'callback_data' => 'start_add_inline_no']
                    ]
                ]
            ];
            
            send_message($chat_id, $msg, $reply_markup);
        } else {
            send_message($chat_id, "❌ خطا! لطفاً دوباره از ابتدا شروع کنید.");
            set_user_state($user_id, null);
        }
    }
    exit;
}

// هندل دریافت دکمه‌های شیشه‌ای برای استارت
if (isset($update['message']) && $state == 'waiting_for_start_inline_data' && is_admin($user_id)) {
    $inline_data = trim($update['message']['text'] ?? '');
    if ($inline_data) {
        // پارس کردن دیتا
        $lines = explode("\n", $inline_data);
        $inline_buttons = [];
        
        foreach ($lines as $line) {
            $line = trim($line);
            if (empty($line)) continue;
            
            // فرمت: متن دکمه | لینک
            if (strpos($line, '|') !== false) {
                list($text, $url) = explode('|', $line, 2);
                $inline_buttons[] = [
                    'text' => trim($text),
                    'url' => trim($url)
                ];
            }
        }
        
        if (empty($inline_buttons)) {
            send_message($chat_id, "❌ فرمت وارد شده صحیح نیست! لطفاً دوباره تلاش کنید.\n\n<b>فرمت صحیح:</b>\n<code>متن دکمه | https://link.com</code>");
            return;
        }
        
        // خواندن اطلاعات قبلی
        $temp_file = __DIR__ . '/temp_start_' . $user_id . '.json';
        if (file_exists($temp_file)) {
            $temp_data = json_decode(file_get_contents($temp_file), true);
            
            // ساخت داده نهایی
            $start_data = [
                'type' => 'text',
                'message' => $temp_data['message'] ?? "👋 سلام!",
                'photo' => $temp_data['photo'] ?? null,
                'inline_buttons' => $inline_buttons,
                'forward_from_chat_id' => null,
                'forward_message_id' => null
            ];
            
            // ذخیره
            save_start_message($start_data);
            
            send_message($chat_id, "✅ متن استارت با موفقیت تنظیم شد!\n\n🎯 پیام استارت برای کاربران نمایش داده می‌شود.");
            
            // حذف فایل موقت
            unlink($temp_file);
            set_user_state($user_id, null);
        } else {
            send_message($chat_id, "❌ خطا! لطفاً دوباره از ابتدا شروع کنید.");
            set_user_state($user_id, null);
        }
    }
    exit;
}


// هندل پیام‌های معمولی برای تنظیم متن جوین اجباری
if (isset($update['message']) && $state == 'waiting_for_forced_join_message' && is_admin($user_id)) {
    $text = trim($update['message']['text'] ?? '');
    if ($text) {
        save_forced_join_message($text);
        send_message($chat_id, "✅ متن جوین اجباری با موفقیت تنظیم شد.");
        set_user_state($user_id, null);
        
        // نمایش مجدد منوی تنظیم متن جوین اجباری
        $menu = "🔐 تنظیم متن جوین اجباری\n\n";
        $menu .= "متن فعلی:\n\n";
        $menu .= $text . "\n\n";
        $menu .= "این متن زمانی که کاربر در کانال‌های اجباری عضو نباشد نمایش داده می‌شود.\n\n";
        $menu .= "برای تنظیم روی دکمه (⚙️ تنظیم متن) ، برای حذف روی دکمه (🗑 حذف متن) که با این کار متن پیش فرض نمایش داده میشه و برای بازگشت روی (🔙 بازگشت) بزنید.";
        
        $reply_markup = [
            'inline_keyboard' => [
                [
                    ['text' => '⚙️ تنظیم متن', 'callback_data' => 'set_forced_join_message'],
                    ['text' => '🗑 حذف متن', 'callback_data' => 'delete_forced_join_message']
                ],
                [['text' => '🔙 بازگشت', 'callback_data' => 'settings_menu']]
            ]
        ];
        
        send_message($chat_id, $menu, $reply_markup);
    }
    exit;
}

// هندل پیام‌های معمولی برای افزودن دکمه سفارشی
if (isset($update['message']) && $state == 'waiting_for_button_name' && is_admin($user_id)) {
    $button_name = trim($update['message']['text'] ?? '');
    if ($button_name) {
        // ذخیره نام در فایل موقت
        $temp_file = __DIR__ . '/temp_button_' . $user_id . '.json';
        $temp_data = ['name' => $button_name];
        file_put_contents($temp_file, json_encode($temp_data, JSON_UNESCAPED_UNICODE));
        
        set_user_state($user_id, 'waiting_for_button_content');
        
        $msg = "➕ <b>افزودن دکمه سفارشی - مرحله 2 از 4</b>\n\n";
        $msg .= "✅ نام دکمه: <b>$button_name</b>\n\n";
        $msg .= "📝 حالا محتوای دکمه را وارد کنید:\n";
        $msg .= "(این متن زمانی که کاربر روی دکمه کلیک کند نمایش داده می‌شود)\n\n";
        $msg .= "💡 از فرمت HTML پشتیبانی می‌شود.";
        
        send_message($chat_id, $msg);
    } else {
        send_message($chat_id, "❌ لطفاً نام دکمه را وارد کنید!");
    }
    exit;
}

if (isset($update['message']) && $state == 'waiting_for_button_content' && is_admin($user_id)) {
    $button_content = trim($update['message']['text'] ?? '');
    if ($button_content) {
        // خواندن اطلاعات قبلی
        $temp_file = __DIR__ . '/temp_button_' . $user_id . '.json';
        if (file_exists($temp_file)) {
            $temp_data = json_decode(file_get_contents($temp_file), true);
            $temp_data['content'] = $button_content;
            file_put_contents($temp_file, json_encode($temp_data, JSON_UNESCAPED_UNICODE));
            
            set_user_state($user_id, 'waiting_for_button_inline_choice');
            
            $msg = "➕ <b>افزودن دکمه سفارشی - مرحله 3 از 4</b>\n\n";
            $msg .= "✅ نام دکمه: <b>" . $temp_data['name'] . "</b>\n";
            $msg .= "✅ محتوا: " . (strlen($button_content) > 50 ? mb_substr($button_content, 0, 50) . "..." : $button_content) . "\n\n";
            $msg .= "🔘 آیا می‌خواهید دکمه‌های شیشه‌ای (لینک‌دار) به این پیام اضافه کنید؟\n\n";
            $msg .= "دکمه‌های شیشه‌ای زیر پیام ظاهر می‌شوند و می‌توانند لینک باشند.";
            
            $reply_markup = [
                'inline_keyboard' => [
                    [
                        ['text' => '✅ بله، اضافه کن', 'callback_data' => 'button_add_inline_yes'],
                        ['text' => '❌ نه، فقط متن', 'callback_data' => 'button_add_inline_no']
                    ]
                ]
            ];
            
            send_message($chat_id, $msg, $reply_markup);
        } else {
            send_message($chat_id, "❌ خطا! لطفاً دوباره از ابتدا شروع کنید.");
            set_user_state($user_id, null);
        }
    } else {
        send_message($chat_id, "❌ لطفاً محتوای دکمه را وارد کنید!");
    }
    exit;
}

if (isset($update['message']) && $state == 'waiting_for_button_inline_data' && is_admin($user_id)) {
    $inline_data = trim($update['message']['text'] ?? '');
    if ($inline_data) {
        // پارس کردن دیتا
        $lines = explode("\n", $inline_data);
        $inline_buttons = [];
        
        foreach ($lines as $line) {
            $line = trim($line);
            if (empty($line)) continue;
            
            // فرمت: متن دکمه | لینک
            if (strpos($line, '|') !== false) {
                list($text, $url) = explode('|', $line, 2);
                $inline_buttons[] = [
                    'text' => trim($text),
                    'url' => trim($url)
                ];
            }
        }
        
        if (empty($inline_buttons)) {
            send_message($chat_id, "❌ فرمت وارد شده صحیح نیست! لطفاً دوباره تلاش کنید.\n\n<b>فرمت صحیح:</b>\n<code>متن دکمه | https://link.com</code>");
            return;
        }
        
        // خواندن اطلاعات قبلی
        $temp_file = __DIR__ . '/temp_button_' . $user_id . '.json';
        if (file_exists($temp_file)) {
            $temp_data = json_decode(file_get_contents($temp_file), true);
            $temp_data['inline_buttons'] = $inline_buttons;
            
            // ذخیره دکمه
            add_custom_button($temp_data);
            
            send_message($chat_id, "✅ دکمه «{$temp_data['name']}» با موفقیت اضافه شد!\n\n🎯 دکمه برای کاربران نمایش داده می‌شود.");
            
            // حذف فایل موقت
            unlink($temp_file);
            set_user_state($user_id, null);
        } else {
            send_message($chat_id, "❌ خطا! لطفاً دوباره از ابتدا شروع کنید.");
            set_user_state($user_id, null);
        }
    } else {
        send_message($chat_id, "❌ لطفاً اطلاعات دکمه‌های شیشه‌ای را وارد کنید!");
    }
    exit;
}

if (isset($update['message']) && $state == 'waiting_for_button_remove' && is_admin($user_id)) {
    $button_name = trim($update['message']['text'] ?? '');
    if ($button_name) {
        $button = get_custom_button_by_name($button_name);
        if ($button) {
            delete_custom_button($button['id']);
            send_message($chat_id, "✅ دکمه «$button_name» با موفقیت حذف شد.");
        } else {
            send_message($chat_id, "❌ دکمه‌ای با این نام یافت نشد.");
        }
        set_user_state($user_id, null);
    } else {
        send_message($chat_id, "❌ لطفاً نام دکمه را وارد کنید!");
    }
    exit;
}

// هندل پیام‌های معمولی برای تنظیم زمان حذف خودکار
if (isset($update['message']) && $state == 'waiting_for_delete_time' && is_admin($user_id)) {
    $text = trim($update['message']['text'] ?? '');
    if (is_numeric($text)) {
        $seconds = intval($text);
        
        if ($seconds < 10 || $seconds > 300) {
            send_message($chat_id, "❌ عدد وارد شده خارج از محدوده است!\n\n📌 لطفاً عددی بین 10 تا 300 وارد کنید.");
            return;
        }
        
        save_auto_delete_time($seconds);
        
        $minutes = floor($seconds / 60);
        $sec = $seconds % 60;
        $time_display = $minutes > 0 ? "$minutes دقیقه و $sec ثانیه" : "$sec ثانیه";
        
        send_message($chat_id, "✅ زمان حذف خودکار به <b>$time_display</b> تنظیم شد.");
        set_user_state($user_id, null);
        
        // نمایش مجدد منوی تنظیمات
        $current_time = get_auto_delete_time();
        $minutes = floor($current_time / 60);
        $seconds_display = $current_time % 60;
        $time_display = $minutes > 0 ? "$minutes دقیقه و $seconds_display ثانیه" : "$seconds_display ثانیه";
        
        $menu = "⏱ تنظیم زمان حذف خودکار پیام\n\n";
        $menu .= "⏰ زمان فعلی: <b>$time_display</b>\n\n";
        $menu .= "پیام‌های موقت (مثل پیام دریافت فایل) بعد از این مدت به صورت خودکار حذف می‌شوند.\n\n";
        $menu .= "🎯 یک زمان را انتخاب کنید یا مقدار دلخواه خود را وارد کنید:";
        
        $reply_markup = [
            'inline_keyboard' => [
                [
                    ['text' => '⚡️ 10 ثانیه', 'callback_data' => 'set_delete_time_10'],
                    ['text' => '30 ثانیه', 'callback_data' => 'set_delete_time_30']
                ],
                [
                    ['text' => '🕐 1 دقیقه', 'callback_data' => 'set_delete_time_60'],
                    ['text' => '2 دقیقه', 'callback_data' => 'set_delete_time_120']
                ],
                [
                    ['text' => '3 دقیقه', 'callback_data' => 'set_delete_time_180'],
                    ['text' => '5 دقیقه ⏰', 'callback_data' => 'set_delete_time_300']
                ],
                [
                    ['text' => '✏️ وارد کردن مقدار دلخواه', 'callback_data' => 'set_custom_delete_time']
                ],
                [['text' => '🔙 بازگشت', 'callback_data' => 'settings_menu']]
            ]
        ];
        
        send_message($chat_id, $menu, $reply_markup);
    } else {
        send_message($chat_id, "❌ لطفاً فقط عدد وارد کنید!\n\nمثال: <code>45</code>");
    }
    exit;
}